using Microsoft.VisualBasic;
using System;
using MicroFour.StrataFrame.Business;
using StrataFlix.Business;
using System.Collections.Generic;


namespace StrataFlix.Reporting
{
	namespace Reports
	{
		namespace MovieProfile
		{
			
			
			public class MoviesBO : StrataFlix.Business.MoviesBO
			{
				
				
				#region " Private Fields "
				
				private static bool _AreCustomDescriptorsEvaluated = false;
				private static MovieImagesBBS _MovieImages = new MovieImagesBBS();
				private static MovieCastBBS _MovieCast = new MovieCastBBS();
				private static MovieItemsBBS _MovieItems = new MovieItemsBBS();
				
				#endregion
				
				#region " Protected Methods "
				
				/// <summary>
				/// Determine if the custom descriptors are going to be evaluated
				/// </summary>
				/// <remarks></remarks>
				protected override bool AreCustomDescriptorsEvaluated
				{
					get
					{
						//-- Establish Locals
						bool r = _AreCustomDescriptorsEvaluated;
						
						//-- Do not eval the desciptors again
						_AreCustomDescriptorsEvaluated = true;
						
						//-- Return results
						return r;
					}
				}
				
				/// <summary>
				/// Add additional binding fields
				/// </summary>
				/// <remarks></remarks>
				protected override MicroFour.StrataFrame.Business.FieldPropertyDescriptor[] GetCustomBindablePropertyDescriptors()
				{
					//-- Establish Locals
					List<FieldPropertyDescriptor> r = new List<FieldPropertyDescriptor>();
					
					//-- Include all of the base descriptors
					try
					{
						r.AddRange(base.GetCustomBindablePropertyDescriptors());
					}
					catch (Exception)
					{
					}
					
					//-- Add the custom descriptors
					r.Add(new ReflectionPropertyDescriptor("MovieCast", typeof(MoviesBO)));
					r.Add(new ReflectionPropertyDescriptor("MovieImages", typeof(MoviesBO)));
					r.Add(new ReflectionPropertyDescriptor("MovieItems", typeof(MoviesBO)));
					r.Add(new ReflectionPropertyDescriptor("mv_RatingText", typeof(MoviesBO)));
					r.Add(new ReflectionPropertyDescriptor("mv_Studio", typeof(MoviesBO)));
					r.Add(new ReflectionPropertyDescriptor("mv_DvdReleaseDateText", typeof(MoviesBO)));
					r.Add(new ReflectionPropertyDescriptor("mv_Genres", typeof(MoviesBO)));
					r.Add(new ReflectionPropertyDescriptor("mv_MediaFormats", typeof(MoviesBO)));
					
					//-- Return results
					return r.ToArray();
				}
				
				#endregion
				
				#region " Public Properties "
				
				/// <summary>
				/// The cast members involved with the movie
				/// </summary>
				/// <value></value>
				/// <returns></returns>
				/// <remarks></remarks>
				public MovieCastBBS MovieCast
				{
					get
					{
						//-- Filter out the child records that match the current movie record
						if (this.Count > 0)
						{
							_MovieCast.SourceBO.Filter = "mc_mv_pk = " + mv_pk.ToString();
						}
						
						//-- Return the child items
						return _MovieCast;
					}
				}
				
				/// <summary>
				/// The movie images associated with a movie
				/// </summary>
				/// <value></value>
				/// <returns></returns>
				/// <remarks></remarks>
				public MovieImagesBBS MovieImages
				{
					get
					{
						//-- Filter out the child records that match the current movie record
						if (this.Count > 0)
						{
							_MovieImages.SourceBO.Filter = "mi_mv_pk = " + this.mv_pk.ToString();
						}
						
						//-- Return the movie images
						return _MovieImages;
					}
				}
				
				/// <summary>
				/// The items associated with a movie
				/// </summary>
				/// <value></value>
				/// <returns></returns>
				/// <remarks></remarks>
				public MovieItemsBBS MovieItems
				{
					get
					{
						//-- Filter out the child records that match the current movie record
						if (this.Count > 0)
						{
							_MovieItems.SourceBO.Filter = "mvi_mv_pk = " + this.mv_pk.ToString();
						}
						
						//-- Return the movie images
						return _MovieItems;
					}
				}
				
				/// <summary>
				/// DVD release date in text format
				/// </summary>
				/// <value></value>
				/// <returns></returns>
				/// <remarks></remarks>
				public string mv_DvdReleaseDateText
				{
					get
					{
						if (mv_DvdReleaseDate == DateTime.Parse("1/1/1800"))
						{
							return "";
						}
						else
						{
							return mv_DvdReleaseDate.ToShortDateString();
						}
					}
				}
				
				/// <summary>
				/// Returns a string with the genres of the movie
				/// </summary>
				/// <value></value>
				/// <returns></returns>
				/// <remarks></remarks>
				public string mv_Genres
				{
					get
					{
						//-- Establish Locals
						string r = "";
						
						foreach (MovieItemsBO bo in _MovieItems.SourceBO.GetEnumerable())
						{
							//-- Only get genre types
							if (bo.mvi_Type != MovieItemType.Genre)
							{
								continue;
							}
							
							//-- See if a / needs to be added
							if (r.Length > 0)
							{
								r += " / ";
							}
							
							//-- Add the genre
							r += MicroFour.StrataFrame.Tools.Common.GetEnumDisplayValue(bo.mvi_Genre);
						}
						
						//-- See if there were any items
						if (r.Length == 0)
						{
							r = "No genres specified";
						}
						
						//-- Return the string
						return r;
					}
				}
				
				/// <summary>
				/// Returns a string with the media formats of the movie
				/// </summary>
				/// <value></value>
				/// <returns></returns>
				/// <remarks></remarks>
				public string mv_MediaFormats
				{
					get
					{
						//-- Establish Locals
						string r = "";
						
						foreach (MovieItemsBO bo in _MovieItems.SourceBO.GetEnumerable())
						{
							//-- Only get media format types
							if (bo.mvi_Type != MovieItemType.Format)
							{
								continue;
							}
							
							//-- See if a / needs to be added
							if (r.Length > 0)
							{
								r += " / ";
							}
							
							//-- Add the format
							r += MicroFour.StrataFrame.Tools.Common.GetEnumDisplayValue(bo.mvi_Format);
						}
						
						//-- See if there were any items
						if (r.Length == 0)
						{
							r = "No media formats specified";
						}
						
						//-- Return the string
						return r;
					}
				}
				
				/// <summary>
				/// Rating in text format
				/// </summary>
				/// <value></value>
				/// <returns></returns>
				/// <remarks></remarks>
				public string mv_RatingText
				{
					get
					{
						return MicroFour.StrataFrame.Tools.Common.GetEnumDisplayValue(mv_Rating);
					}
				}
				
				/// <summary>
				/// Studio name in text format
				/// </summary>
				/// <value></value>
				/// <returns></returns>
				/// <remarks></remarks>
				public string mv_Studio
				{
					get
					{
						return StudiosBO.GetStudioName(mv_st_pk);
					}
				}
				
				#endregion
				
			}
			
			
		}
	}
}
